/*------------------------------------------------------------------------------*
 * File Name: RadioButtons.h				 									*
 * Creation: GJL 11/19/03 														*
 * Purpose: OriginC header file containing Radio Buttons example dialog.		*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007		 		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

// Radio Buttons Dialog derived class
class RadioButtons : public Dialog
{
public:

	// Constructor
	RadioButtons() : Dialog(IDD_ST_SET_TICKS_DLG, "Radio Buttons") { }

	// Launch dialog
	int DoModal(HWND hParent = NULL)
	{
		InitMsgMap(); // Will be called from internal later
		int nRet = Dialog::DoModal(hParent);
		return nRet;
	}

protected:

	// Message Map
	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		ON_OK(OnOK)
		ON_BN_CLICKED(IDC_ST_INCREMENT_RB, OnClickRadioButtons)
		ON_BN_CLICKED(IDC_ST_NO_MAJOR_RB, OnClickRadioButtons)
	EVENTS_END

	// Initialize radio buttons and edit boxes 
	BOOL OnInitDialog()
	{
		m_rbIncrement = GetItem(IDC_ST_INCREMENT_RB); // Get Increment radio button
		m_ebxIncrement = GetItem(IDC_ST_INCREMENT_EBX); // Get Increment edit box
		m_rbNumMajorTicks = GetItem(IDC_ST_NO_MAJOR_RB); // Get NumMajorTicks radio button
		m_ebxNumMajorTicks = GetItem(IDC_ST_NO_MAJOR_EBX); // Get NumMajorTicks edit box

		m_rbIncrement.Check = 1;
		m_ebxIncrement.Text = "10";
		m_rbNumMajorTicks.Check = 0;
		m_ebxNumMajorTicks.Text = "2";
		EnableEditBoxes(0); // 0 to enable Increment edit box and 1 for NumMajorTicks
		
		return TRUE;
	}

	// Output selected item in list box
	BOOL OnOK()
	{
		string strOut;
		
		if( m_rbIncrement.Check )
			strOut.Format("Set Ticks: Increment of %s", m_ebxIncrement.Text);
		else
			strOut.Format("Set Ticks: # Major Ticks is %s", m_ebxNumMajorTicks.Text);
		strOut.Write(WRITE_MESSAGE_BOX);
		return TRUE;
	}

	// Event handler for clicking Radio Buttons
	BOOL OnClickRadioButtons(Control Cntrl)
	{
		int iRadioButtonSelected;
		
		// Alternative methods
		iRadioButtonSelected = GetCheckedRadioButton(IDC_ST_INCREMENT_RB, IDC_ST_NO_MAJOR_RB) - IDC_ST_INCREMENT_RB;
//		iRadioButtonSelected = m_rbNumMajorTicks.Check;
		EnableEditBoxes(iRadioButtonSelected); // 0 to enable Increment edit box and 1 for NumMajorTicks 
		return TRUE;
	}

	void EnableEditBoxes(int iRB)
	{
		m_ebxIncrement.Enable = mod(iRB + 1, 2);
		m_ebxNumMajorTicks.Enable = iRB;
	}

private:

	Edit m_ebxIncrement; // Declare Icrement edit box control
	Edit m_ebxNumMajorTicks; // Declare NumMajorTicks edit box control
	Button m_rbIncrement; // Declare Increment radio button control
	Button m_rbNumMajorTicks; // Declare NumMajorTicks radio button control 
};
